package jadean.ui.java.wizards;

import jadean.dean.java.JavaPackage;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;


class JavaPackageLabelProvider implements ITableLabelProvider {

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof JavaPackage) {
			JavaPackage jp = (JavaPackage) element;
			return jp.getPath();
		}
		return null;
	}
	
}

public class BasicInformationPage extends WizardPage {
	private Text projectName;
	private Text projectOutputFolder;
	private Composite container;
	private Composite smallContainer;
	private Composite largeContainer;
	private WizardInput input;
	private Table sourceFoldersTB;
	private Table referencedLibrariesTB;
	private TableViewer sourceFoldersTV;
	private TableViewer referencedLibrariesTV;

	public BasicInformationPage(WizardInput input) {
		super("Project basic information");
		setTitle("Project basic information");
		setDescription("This page shows basic project information such as project name, source folders, output folder and list of referenced libraries");
		this.input = input;	
	}

	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.FILL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		container.setLayout(new GridLayout());
		
		smallContainer = new Composite(container, SWT.FILL);
		smallContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		GridLayout l2 = new GridLayout();
		smallContainer.setLayout(l2);
		l2.numColumns = 2;
		
		Label label1 = new Label(smallContainer, SWT.NULL);
		label1.setText("Project name: ");

		projectName = new Text(smallContainer, SWT.BORDER | SWT.SINGLE | SWT.FILL);
		projectName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		projectName.setText(this.input.getProject().getProjectName());
		
		Label label2 = new Label(smallContainer, SWT.NULL);
		label2.setText("Project output folder: ");		
		
		projectOutputFolder = new Text(smallContainer, SWT.BORDER | SWT.SINGLE | SWT.FILL);
		projectOutputFolder.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		projectOutputFolder.setText(this.input.getProject().getOutputFolder());
		
		largeContainer = new Composite(container, SWT.FILL);
		largeContainer.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		GridLayout l3 = new GridLayout();
		largeContainer.setLayout(l3);
		l3.numColumns = 3;
		
		Label sourceFoldersLB = new Label(largeContainer, SWT.UP);
		sourceFoldersLB.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		sourceFoldersLB.setText("Project source folders: ");
		
		sourceFoldersTV = new TableViewer(largeContainer, SWT.BORDER | SWT.FULL_SELECTION);
		sourceFoldersTV.setContentProvider(new ArrayContentProvider());
		sourceFoldersTV.setInput(this.input.getProject().getSourceFolders());
		sourceFoldersTB = sourceFoldersTV.getTable();
		sourceFoldersTB.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Composite sourceFoldersButtonsCO = new Composite(largeContainer, SWT.NONE);
		sourceFoldersButtonsCO.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		GridLayout bl = new GridLayout();
		bl.numColumns = 1;
		sourceFoldersButtonsCO.setLayout(bl);
		
		Button addSourceFolderBT = new Button(sourceFoldersButtonsCO, SWT.NONE);
		addSourceFolderBT.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				DirectoryDialog dd = new DirectoryDialog(getShell(), SWT.OPEN);
				dd.setFilterPath(input.getPath());
				String s = dd.open();
				if (s != null) {
					sourceFoldersTV.add(s);
					input.getProject().getSourceFolders().add(s);
					input.notifyListeners();
				}
			}
		});
		addSourceFolderBT.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		addSourceFolderBT.setText("Add");
		Button removeSourceFolderBT = new Button(sourceFoldersButtonsCO, SWT.NONE);
		removeSourceFolderBT.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				if (sourceFoldersTB.getSelectionIndex() < 0) return;
				sourceFoldersTB.remove(sourceFoldersTB.getSelectionIndex());
				input.getProject().getSourceFolders().remove(sourceFoldersTB.getSelectionIndex());
				input.notifyListeners();
			}
		});
		removeSourceFolderBT.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		removeSourceFolderBT.setText("Remove");		
		
		Label label4 = new Label(largeContainer, SWT.NULL);
		label4.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		label4.setText("Project referenced libraries: ");
		
		referencedLibrariesTV = new TableViewer(largeContainer, SWT.BORDER | SWT.FULL_SELECTION);
		referencedLibrariesTV.setContentProvider(new ArrayContentProvider());
		referencedLibrariesTV.setLabelProvider(new JavaPackageLabelProvider());
		referencedLibrariesTV.setInput(this.input.getProject().getReferencedPackages());	
		referencedLibrariesTB = referencedLibrariesTV.getTable();
		referencedLibrariesTB.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Composite referencedLibrariesButtonsCO = new Composite(largeContainer, SWT.NONE);
		referencedLibrariesButtonsCO.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		GridLayout bl2 = new GridLayout();
		bl2.numColumns = 1;
		referencedLibrariesButtonsCO.setLayout(bl2);		
		Button addReferencedLibraryBT = new Button(referencedLibrariesButtonsCO, SWT.CENTER);
		addReferencedLibraryBT.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		addReferencedLibraryBT.setText("Add");
		addReferencedLibraryBT.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				FileDialog dd = new FileDialog(getShell(), SWT.OPEN);
				dd.setFilterPath(input.getPath());
				dd.setFilterExtensions(new String[] {"*.jar"});
				dd.setFilterNames(new String[] {"JAR file"});
				String s = dd.open();
				if (s != null) {
					referencedLibrariesTV.add(new JavaPackage(s));
					input.getProject().getReferencedPackages().add(new JavaPackage(s));
					input.notifyListeners();
				}
			}
		});
		Button removeReferencedLibrary = new Button(referencedLibrariesButtonsCO, SWT.NONE);
		removeReferencedLibrary.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		removeReferencedLibrary.setText("Remove");
		removeReferencedLibrary.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				if (referencedLibrariesTB.getSelectionIndex() < 0) return;
				referencedLibrariesTB.remove(referencedLibrariesTB.getSelectionIndex());
				input.getProject().getReferencedPackages().remove(referencedLibrariesTB.getSelectionIndex());
			}
		});
		
		input.addListener(new WizardInputChangedListener() {
			public void inputChanged() {
				try {
				sourceFoldersTV.refresh();
				referencedLibrariesTV.refresh();
				}
				catch (Exception e) {
				}
			}
		});		
		
		setControl(container);
		setPageComplete(true);
		input.notifyListeners();
		
	}
	
}
